#!/bin/sh
########################################################################
########################################################################
#                                                                      #
#  This script will display a notification dialog.                     #
#                                                                      #
#  Parameters: <"SUCCESS"|"ERROR"> <message>                           #
########################################################################

# Message
message=$2

# Notification mode
mode=$1


# Check if zenity is available
zenity --help > /dev/null 2>&1
if [ $? -eq 0 ]; then
	mode_param="--info" 
	if [ -n "${mode}" ] && [ "${mode}" = 'ERROR' ]; then
		mode_param="--error"
	fi

	# Launch file-selection dialog for GNOME
	zenity ${mode_param} --text="${message}"
else
	mode_param="--msgbox" 
	if [ -n "${mode}" ] && [ "${mode}" = 'ERROR' ]; then
		mode_param="--error"
	fi

	# Launch file-selection dialog for KDE
	kdialog "${mode_param}" "${message}" > /dev/null 2>&1
fi

